;RS232 Control Byte Routines

Read_USART_RX_FIFO:	;Reads and acts on USART buffer bytes

		Set_FIFO_Address USART_RX_FIFO
		call FIFO_Read					;Get byte

		lds ZL,Read_USART_Jump_Adr
		lds ZH,(Read_USART_Jump_Adr+1)
		ijmp


Read_USART_RX_FIFO_Default:
		cpi r16,DC1
		brne Read_USART_RX_FIFO_Default_A

		ldi r16,low(Read_USART_RX_FIFO_DC1_B0)
		ldi r17,high(Read_USART_RX_FIFO_DC1_B0)

		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set new jump vector

		ret								;Exit
		
		
Read_USART_RX_FIFO_Default_A:
		cpi r16,DC2
		brne Read_USART_RX_FIFO_Default_B

		ldi r16,low(Read_USART_RX_FIFO_DC2_B0)
		ldi r17,high(Read_USART_RX_FIFO_DC2_B0)

		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set new jump vector

		ret								;Exit
		

Read_USART_RX_FIFO_Default_B:
		cpi r16,DC3
		brne Read_USART_RX_FIFO_Default_C

		ldi r16,low(Read_USART_RX_FIFO_DC3_B0)
		ldi r17,high(Read_USART_RX_FIFO_DC3_B0)

		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set new jump vector

		ret								;Exit


Read_USART_RX_FIFO_Default_C:
		cpi r16,DC4
		brne Read_USART_RX_FIFO_Default_D

		ldi r16,low(Read_USART_RX_FIFO_DC4_B0)
		ldi r17,high(Read_USART_RX_FIFO_DC4_B0)

		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set new jump vector

		ret								;Exit

Read_USART_RX_FIFO_Default_D:
		;not a control byte
		mov r17,DC1_B0
		cbr r17,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

		cpi r17,0
		brne Read_USART_RX_FIFO_Default_E

		;VD=00
		Set_FIFO_Address LCD_FIFO
		call FIFO_Write					;Send byte to LCD
		
		ret


Read_USART_RX_FIFO_Default_E:
		;VD !=0
		;ignore non control bytes when LCD displays PWM and ADC values

		ret


Read_USART_RX_FIFO_DC1_B0:
		mov r17,DC1_B0					;Get old DC1_B0 for comparison
		
		mov DC1_B0,r16					;Set DC1_B0

		;test VD for change
		cbr r16,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)
		cbr r17,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

		cp r16,r17						;compare old with new VD values
		breq Read_USART_RX_FIFO_DC1_B0_A

		;VD has changed
		Set_FIFO_Address LCD_FIFO
		ldi r16,LCD_FIFO_Size
		call FIFO_Init					;clear any pending LCD bytes

		ldi r16,254
		call FIFO_Write

		ldi r16,0b00000001
		call FIFO_Write					;Clear display, adr=0


Read_USART_RX_FIFO_DC1_B0_A:
		mov r16,DC1_B0
		cbr r16,(1<<SAS | 1<<SDS | 1<<SSP | 1<<VDM | 1<<R_W | 1<<BKL)

		brne Read_USART_RX_FIFO_DC1_B0_B
		;VD = 00

		mov r16,Ticker_Flags
		cbr r16,(1<<Update_LCD1 | 1<<Test_LCD1)
		mov Ticker_Flags,r16		;Stop further LCD1 tests

		rjmp Read_USART_RX_FIFO_DC1_B0_C

Read_USART_RX_FIFO_DC1_B0_B:
		;VD != 00
		mov r16,Ticker_Flags
		sbr r16,(1<<Update_LCD1 | 1<<Test_LCD1)
		mov Ticker_Flags,r16		;Enable LCD1 tests

		clr LCD_C1L
		clr LCD_C1H					;LCD1 ticker counter = 0


Read_USART_RX_FIFO_DC1_B0_C:
		;Set Backlight
		rcall Set_BKL

		;SAS tests
		sbrs DC1_B0,SAS
		rjmp Read_USART_RX_FIFO_DC1_B0_F ;SAS=0

		;SAS = 1
		mov r16,DC1_B0
		cbr r16,(1<<R_W | 1<<SDS)
		mov DC1_B0,r16				;SAS clears R_W and SDS

		;Write settings to EEPROM
		mov r16,Immediate_Flags
		sbrc r16,Test_EEPROM_FIFO
		rjmp Read_USART_RX_FIFO_DC1_B0_D

		;EEPROM already writing, send NAK message
		Set_FIFO_Address USART_TX_FIFO
		ldi r16,DC1					;DC1
		call FIFO_Write

		ldi r16,ETB					;ETB
		call FIFO_Write

		rjmp Read_USART_RX_FIFO_DC1_B0_F

Read_USART_RX_FIFO_DC1_B0_D:

		ldi r16,low(EE_DC1)
		ldi r17,high(EE_DC1)
		sts EEPROM_Write_Address,r16
		sts (EEPROM_Write_Address+1),r17	;Set EEPROM write address

		Set_FIFO_Address EEPROM_FIFO
		mov r16,DC1_B0						;DC1
		call FIFO_Write

		mov r16,DC2_B0						;DC2
		call FIFO_Write

		mov r16,DC3_B0						;DC3
		call FIFO_Write

		mov r16,DC4_B0						;DC4
		call FIFO_Write

		in r16,OCR0							;PWM0
		call FIFO_Write

		in r16,OCR1AL						;PWM1
		call FIFO_Write

		in r16,OCR1BL						;PWM2
		call FIFO_Write

		in r16,OCR2							;PWM3
		call FIFO_Write

		ldi r19,88							;88 Name characters
		ldi XL,low(PWM0_Name)
		ldi XH,high(PWM0_Name)				;Starting with PWM0_Name

Read_USART_RX_FIFO_DC1_B0_E:
		ld r16,X+							;Character_N
		call FIFO_Write

		dec r19
		brne Read_USART_RX_FIFO_DC1_B0_E

		;EEPROM loaded.

Read_USART_RX_FIFO_DC1_B0_F:
		;SDS tests
		sbrc DC1_B0,SDS
		rjmp Read_USART_RX_FIFO_DC1_B0_G

		;SDS = 0
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret


Read_USART_RX_FIFO_DC1_B0_G:

		;SDS = 1
		ldi r16,low(Read_USART_RX_FIFO_DC1_B1)
		ldi r17,high(Read_USART_RX_FIFO_DC1_B1)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret		



Read_USART_RX_FIFO_DC1_B1:
		mov r17,r16						;copy B1 byte for comparisons

		cbr r17,0xF0					;clear high nibble (N)
		
		cpi r17,0x00
		brne Read_USART_RX_FIFO_DC1_B1_A

		;PWM0 name
		ldi r17,low(PWM0_Name)
		ldi r18,high(PWM0_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J

		
Read_USART_RX_FIFO_DC1_B1_A:
		cpi r17,0x01
		brne Read_USART_RX_FIFO_DC1_B1_B

		;PWM1 name
		ldi r17,low(PWM1_Name)
		ldi r18,high(PWM1_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_B:
		cpi r17,0x02
		brne Read_USART_RX_FIFO_DC1_B1_C

		;PWM2 name
		ldi r17,low(PWM2_Name)
		ldi r18,high(PWM2_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_C:
		cpi r17,0x03
		brne Read_USART_RX_FIFO_DC1_B1_D

		;PWM3 name
		ldi r17,low(PWM3_Name)
		ldi r18,high(PWM3_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_D:
		cpi r17,0x04
		brne Read_USART_RX_FIFO_DC1_B1_E

		;ADC0 name
		ldi r17,low(ADC0_Name)
		ldi r18,high(ADC0_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_E:
		cpi r17,0x05
		brne Read_USART_RX_FIFO_DC1_B1_F

		;ADC1 name
		ldi r17,low(ADC1_Name)
		ldi r18,high(ADC1_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_F:
		cpi r17,0x06
		brne Read_USART_RX_FIFO_DC1_B1_G

		;ADC2 name
		ldi r17,low(ADC2_Name)
		ldi r18,high(ADC2_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_G:
		cpi r17,0x07
		brne Read_USART_RX_FIFO_DC1_B1_H

		;ADC3 name
		ldi r17,low(ADC3_Name)
		ldi r18,high(ADC3_Name)
		sts Read_USART_Name_Adr,r17
		sts (Read_USART_Name_Adr+1),r18	;Store name address

		rjmp Read_USART_RX_FIFO_DC1_B1_J


Read_USART_RX_FIFO_DC1_B1_H:
		cpi r17,0x08
		brne Read_USART_RX_FIFO_DC1_B1_I

		;Save start up message

		;Write settings to EEPROM
		mov r16,Immediate_Flags
		sbrc r16,Test_EEPROM_FIFO
		rjmp Read_USART_RX_FIFO_DC1_B1_L

		;EEPROM already writing, send NAK message
		Set_FIFO_Address USART_TX_FIFO
		ldi r16,DC1					;DC1
		call FIFO_Write

		ldi r16,ETB					;ETB
		call FIFO_Write

		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC1_B1_I:
		;invalid M value
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC1_B1_J:
		cbr r16,0x0F
		swap r16						;get counter value

		cpi r16,11
		brlo Read_USART_RX_FIFO_DC1_B1_K

		;N>10
		ldi r16,10

Read_USART_RX_FIFO_DC1_B1_K:
		;N<=10
		sts Read_USART_Counter,r16	;set counter

		lds ZL,Read_USART_Name_Adr
		lds ZH,Read_USART_Name_Adr+1
		
		st Z+,r16					;Store N in SRAM name space
		
		sts Read_USART_Name_Adr,ZL
		sts (Read_USART_Name_Adr+1),ZH	;Save new SRAM pointer 

		ldi r16,low(Read_USART_RX_FIFO_DC1_B1_Str)
		ldi r17,high(Read_USART_RX_FIFO_DC1_B1_Str)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC1_B1_L:
		ldi r16,80
		sts Read_USART_Counter,r16		;Counter = 80

		ldi r16,low(EE_Start_Msg_0)
		ldi r17,high(EE_Start_Msg_0)
		sts EEPROM_Write_Address,r16
		sts (EEPROM_Write_Address+1),r17	;Set EEPROM write address

		ldi r16,low(Read_USART_RX_FIFO_DC1_B1_EEP)
		ldi r17,high(Read_USART_RX_FIFO_DC1_B1_EEP)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret


Read_USART_RX_FIFO_DC1_B1_Str:
		lds ZL,Read_USART_Name_Adr
		lds ZH,Read_USART_Name_Adr+1	;Get address pointer
		
		st Z+,r16					;Store character in SRAM

		sts Read_USART_Name_Adr,ZL
		sts (Read_USART_Name_Adr+1),ZH	;Save new SRAM pointer

		lds r17,Read_USART_Counter		;Get counter

		dec r17
		brne Read_USART_RX_FIFO_DC1_B1_Str_A

		;counter = 0
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret


Read_USART_RX_FIFO_DC1_B1_Str_A:

		;counter != 0
		sts Read_USART_Counter,r17		;Save counter

		ret


Read_USART_RX_FIFO_DC1_B1_EEP:
		Set_FIFO_Address EEPROM_FIFO
		call FIFO_Write					;Write byte to EEPROM FIFO

		lds r17,Read_USART_Counter		;Get counter

		dec r17
		brne Read_USART_RX_FIFO_DC1_B1_EEP_A

		;counter = 0
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret


Read_USART_RX_FIFO_DC1_B1_EEP_A:

		;counter != 0
		sts Read_USART_Counter,r17		;Save counter

		ret





Read_USART_RX_FIFO_DC2_B0:
		mov DC2_B0,r16					;Set DC2_B0

		sbrs DC2_B0,SPV
		rjmp Read_USART_RX_FIFO_DC2_B0_A

		;send PWM values
		Set_FIFO_Address USART_TX_FIFO
		ldi r16,DC2						;DC2
		call FIFO_Write

		ldi r16,'P'						;P
		call FIFO_Write

		in r16,OCR0						;PWM0
		call FIFO_Write

		in r16,OCR1AL					;PWM1
		call FIFO_Write

		in r16,OCR1BL					;PWM2
		call FIFO_Write

		in r16,OCR2						;PWM3
		call FIFO_Write

		ldi r16,ETB						;ETB
		call FIFO_Write

Read_USART_RX_FIFO_DC2_B0_A:
		sbrs DC2_B0,SAV
		rjmp Read_USART_RX_FIFO_DC2_B0_C

		;send ADC values
		sbrs DC2_B0,AVM
		rjmp Read_USART_RX_FIFO_DC2_B0_B

		;10/16 bit
		Set_FIFO_Address USART_TX_FIFO
		ldi r16,DC2						;DC2
		call FIFO_Write

		ldi r16,'A'						;A
		call FIFO_Write

		lds r16,ADC0_Val				;ADC0L
		call FIFO_Write

		lds r16,ADC0_Val+1				;ADC0H
		call FIFO_Write

		lds r16,ADC1_Val				;ADC1L
		call FIFO_Write

		lds r16,ADC1_Val+1				;ADC1H
		call FIFO_Write

		lds r16,ADC2_Val				;ADC2L
		call FIFO_Write

		lds r16,ADC2_Val+1				;ADC2H
		call FIFO_Write

		lds r16,ADC3_Val				;ADC3L
		call FIFO_Write

		lds r16,ADC3_Val+1				;ADC3H
		call FIFO_Write

		ldi r16,ETB						;ETB
		call FIFO_Write

		rjmp Read_USART_RX_FIFO_DC2_B0_C


Read_USART_RX_FIFO_DC2_B0_B:
		;8 bit
		Set_FIFO_Address USART_TX_FIFO
		ldi r16,DC2						;DC2
		call FIFO_Write

		ldi r16,'A'						;A
		call FIFO_Write

		lds r16,ADC0_Val+1				;ADC0H
		call FIFO_Write

		lds r16,ADC1_Val+1				;ADC1H
		call FIFO_Write

		lds r16,ADC2_Val+1				;ADC2H
		call FIFO_Write

		lds r16,ADC3_Val+1				;ADC3H
		call FIFO_Write

		ldi r16,ETB						;ETB
		call FIFO_Write

Read_USART_RX_FIFO_DC2_B0_C:
		sbrs DC2_B0,KPC
		rjmp Read_USART_RX_FIFO_DC2_B0_D

		mov r16,DC2_B0
		cbr r16,(1<<MC0 | 1<<MC1 | 1<<MC2 | 1<<MC3)
		mov DC2_B0,r16					;KPC clears MC bits

Read_USART_RX_FIFO_DC2_B0_D:
		ldi r16,low(Read_USART_RX_FIFO_DC2_B1)
		ldi r17,high(Read_USART_RX_FIFO_DC2_B1)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret


Read_USART_RX_FIFO_DC2_B1:
		sbrc DC2_B0,MC0
		rjmp Read_USART_RX_FIFO_DC2_B1_A

		sbrs DC2_B0,KPC
		out OCR0,r16

Read_USART_RX_FIFO_DC2_B1_A:
		ldi r16,low(Read_USART_RX_FIFO_DC2_B2)
		ldi r17,high(Read_USART_RX_FIFO_DC2_B2)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC2_B2:
		sbrc DC2_B0,MC1
		rjmp Read_USART_RX_FIFO_DC2_B2_A

		sbrs DC2_B0,KPC
		out OCR1AL,r16

Read_USART_RX_FIFO_DC2_B2_A:
		ldi r16,low(Read_USART_RX_FIFO_DC2_B3)
		ldi r17,high(Read_USART_RX_FIFO_DC2_B3)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC2_B3:
		sbrc DC2_B0,MC2
		rjmp Read_USART_RX_FIFO_DC2_B3_A

		sbrs DC2_B0,KPC
		out OCR1BL,r16

Read_USART_RX_FIFO_DC2_B3_A:
		ldi r16,low(Read_USART_RX_FIFO_DC2_B4)
		ldi r17,high(Read_USART_RX_FIFO_DC2_B4)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret

Read_USART_RX_FIFO_DC2_B4:
		sbrc DC2_B0,MC3
		rjmp Read_USART_RX_FIFO_DC2_B4_A

		sbrs DC2_B0,KPC
		out OCR2,r16

Read_USART_RX_FIFO_DC2_B4_A:
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret



Read_USART_RX_FIFO_DC3_B0:
		mov DC3_B0,r16					;Set DC3_B0

		sbrc DC3_B0,KON
		rjmp Read_USART_RX_FIFO_DC3_B0_A

		in r16,GICR
		cbr r16,(1<<INT0 | 1<<INT1 | 1<<INT2)
		out GICR,r16					;Turn keypad off

		rjmp Read_USART_RX_FIFO_DC3_B0_B

Read_USART_RX_FIFO_DC3_B0_A:
		ldi r16,(1<<INTF1 | 1<<INTF0 | 1<<INTF2)
		out GIFR,r16					;Clear flags
	
		in r16,GICR
		sbr r16,(1<<INT0 | 1<<INT1 | 1<<INT2)
		out GICR,r16					;Turn keypad on

Read_USART_RX_FIFO_DC3_B0_B:
		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret		


Read_USART_RX_FIFO_DC4_B0:
		mov DC4_B0,r16					;Set DC4_B0

		call Set_GPO

		;INDC is configured during ADC ISR

		ldi r16,low(Read_USART_RX_FIFO_Default)
		ldi r17,high(Read_USART_RX_FIFO_Default)
		sts Read_USART_Jump_Adr,r16
		sts (Read_USART_Jump_Adr+1),r17	;Set Jump Vector

		ret



Set_BKL:
		in r16,LCD_Port					;Get port value

		cbr r16,(1<<BKL)
		sbrc DC1_B0,BKL
		sbr r16,(1<<BKL)

		out LCD_Port,r16

		ret

Set_GPO:
		in r16,PORTB					;Get port values
		in r17,PORTD

		cbr r16,(1<<PB0 | 1<<PB1)		;Set pins refs to zero
		cbr r17,(1<<PD6)			

		sbrc DC4_B0,GPO0				;Set GPO0
		sbr r16,(1<<PB0)

		sbrc DC4_B0,GPO1				;Set GPO1
		sbr r16,(1<<PB1)

		sbrc DC4_B0,GPO2				;Set GPO2
		sbr r17,(1<<PD6)

		out PORTB,r16
		out PORTD,r17					;Set Port Values

		ret